function [buf,SampleRate,adcpins]=udpadcmon(skt,SamplesToGet)
%[buf,SampleRate,adcpins]=udpadcmon(skt,SamplesToGet)  
% Functon showing how to use PIC board as adc that can be monitored
% by many other processes or processors
%
% See function udpadc for how to set up the PIC

pins=(16:-1:1).*([zeros(1,16) uint8(dec2bin(udpget(skt,'AD1CSSL')))-'0']((end-15):end));
pidx=find(pins>0);
adcpins=pins(pidx); % work out what pins are used in adc and hence NumChan
NumChan=max(size(adcpins));
CPU_Speed=udpget(skt,'CPU_SPEED');
Timer_Divisor=udpget(skt,'PR5')+1;  % work out sample rate
SampleRate=CPU_Speed/((Timer_Divisor+1)*NumChan);
DMA_base_addr=udpget(skt,'DMA_BASE');
[d,DMABUF_ADDR]=udpget(skt,'DMABufferA');
[adcval,ADC_ADDR]=udpget(skt,'ADC1BUF0');
DMABufferSize=max(size(d)); % in words not bytes as type is uint16
DMABufferSize=NumChan*floor(DMABufferSize/NumChan); % whole number of sample frames in a buffer
 %treat DMA as fifo and chase the head
 tail=(udpget(skt,'DMA0STA')+DMA_base_addr-DMABUF_ADDR)/2+1;
 tail=NumChan*floor((tail-1)/NumChan)+1; % Start at first channel
 pause(1/SampleRate); %wait at least 1 sample
 buf=[];
 cnt=0;
 while(cnt<(SamplesToGet*NumChan))
  ptr=(udpget(skt,'DMA0STA')+DMA_base_addr-DMABUF_ADDR)/2+1;
  data=udpget(skt,'DMABufferA');
  if (tail>ptr)
   buf=[buf data(tail:DMABufferSize)];
   cnt=cnt+DMABufferSize-tail+1;
   tail=1; 
  end 
  if (ptr>tail) 
   buf=[buf data(tail:(ptr-1))];
   cnt=cnt+ptr-tail;
   tail=ptr;
  end
 end
 
 % Top and tail the buffers
 buf=buf(1:(SamplesToGet*NumChan));
 buf=reshape(buf,NumChan,SamplesToGet)';
end